/*******************************************************************************
* Token                                                                        *
********************************************************************************
* (C) 2005-2011 Dr. Klaus Rieger                                               *
********************************************************************************
* $Rev:: 3                                                  $: Revision        *
* $Author:: rieger                                          $: Author          *
* $Date:: 2010-01-12                                        $: Date            *
*******************************************************************************/


package nmm;


public class Token
{
	static final int nine = 1;							// 0 six tokens, 1 nine tokens
	static final int wma_rule = 1;						// 0 WMD Rules: Any piece may be taken, except those being in closed mills
														// 1 WMA Rules: ". However, if all the opponent's stones are in mills, you may remove any stone
	static final int australia = 0;						// 0 three tokens => jumping allowed
														// 1 jumping never allowed
	static int ATTACK;									// aggressiveness


	/* related to ATTACK */

	public Token(int attack)
	{
		ATTACK = attack;
	}

	public int getAttack()
	{
		return ATTACK;
	}


	/* related to id */

	int [] location = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					   1, 1, 1, 1, 1, 1, 1*nine, 1*nine, 1*nine, 0,	// 0 empty, 1 white, 2 black
					   2, 2, 2, 2, 2, 2, 2*nine, 2*nine, 2*nine, 0};// location of tokens at start (44)
	int [][] neighbor = {{ 1, 7, 8,-1}, { 0, 2,-1,-1}, { 1, 3,10,-1}, { 2, 4,-1,-1},
						 { 3, 5,12,-1}, { 4, 6,-1,-1}, { 5, 7,14,-1}, { 0, 6,-1,-1},
						 { 0, 9,15,16}, { 8,10,-1,-1}, { 2, 9,11,18}, {10,12,-1,-1},
						 { 4,11,13,20}, {12,14,-1,-1}, { 6,13,15,22}, { 8,14,-1,-1},
						 { 8,17,23,-1}, {16,18,-1,-1}, {10,17,19,-1}, {18,20,-1,-1},
						 {12,19,21,-1}, {20,22,-1,-1}, {14,21,23,-1}, {16,22,-1,-1},
						 {-1,-1,-1,-1}, {-1,-1,-1,-1}, {-1,-1,-1,-1}, {-1,-1,-1,-1}, {-1,-1,-1,-1},
						 {-1,-1,-1,-1}, {-1,-1,-1,-1}, {-1,-1,-1,-1}, {-1,-1,-1,-1}, {-1,-1,-1,-1},
						 {-1,-1,-1,-1}, {-1,-1,-1,-1}, {-1,-1,-1,-1}, {-1,-1,-1,-1}, {-1,-1,-1,-1},
						 {-1,-1,-1,-1}, {-1,-1,-1,-1}, {-1,-1,-1,-1}, {-1,-1,-1,-1}, {-1,-1,-1,-1}};

	int [][] line = {{ 1, 7, 8,16}, { 0, 7, 2, 3}, { 1, 3,10,18}, { 1, 2, 4, 5},
					 { 3, 5,12,20}, { 3, 4, 6, 7}, { 5, 7,14,22}, { 0, 1, 5, 6},
					 { 0,16, 9,15}, { 8,15,10,11}, { 2,18, 9,11}, { 9,10,12,13},
					 {11,13, 4,20}, {11,12,14,15}, {13,15, 6,22}, { 8, 9,13,14},
					 { 0, 8,17,23}, {18,19,16,23}, { 2,10,17,19}, {17,18,20,21},
					 { 4,12,19,21}, {19,20,22,23}, { 6,14,21,23}, {16,17,21,22}};

	int [] put = {6 + 3*nine, 6 + 3*nine};				// number of tokens to set (2)
	int [] posput = {24, 34};							// top position of tokens to set (2)
	int [] capture = {0, 0};							// number of captured tokens (2)
	int [] poscapture = {33, 43};						// bottom position of captured tokens (2)
	int movefrom = -1;									// last move from id
	int moveto = -1;									// last move to id
	int captured = -1;									// id of last captured token
	int from = -1;										// id of first selection
	int move = 0;										// move extracted in string2location



	/* related to position */

	int [][] position = {{ 6,24}, { 6,30}, { 9,30}, {12,30}, {12,24}, {12,18}, { 9,18}, { 6,18},
						 { 3,24}, { 3,36}, { 9,36}, {15,36}, {15,24}, {15,12}, { 9,12}, { 3,12},
						 { 0,24}, { 0,42}, { 9,42}, {18,42}, {18,24}, {18, 6}, { 9, 6}, { 0, 6},
						 { 0, 0}, { 2, 0}, { 4, 0}, { 6, 0}, { 8, 0}, {10, 0}, {12, 0}, {14, 0}, {16, 0},{18, 0},
						 { 0,48}, { 2,48}, { 4,48}, { 6,48}, { 8,48}, {10,48}, {12,48}, {14,48}, {16,48},{18,48}};
														// position of tokens on the screen (44)


	public int calculate(int depth, int main)
	{												// prepare automatic movements:
													// max depth	depth		moves		best_scope
													// 0			-			(if   nothing   found)
													// 1			0			1			9000
													// 2			0			2			9000
													//				1			1			9100
													// 3			0			3			9000
													//				1			2			9100
													//				2			1			9200
													// 4			0			4			9000
													//				1			3			9100
													//				2			2			9200
													//				3			1			9300
													// 5			0			5			9000
													//				1			4			9100
													//				2			3			9200
													//				3			2			9300
													//				4			1			9400
													// 6			0			6			9000
													//				1			5			9100
													//				2			4			9200
													//				3			3			9300
													//				4			2			9400
													//				5			1			9500
													// 7			0			7			9000
													//				1			6			9100
													//				2			5			9200
													//				3			4			9300
													//				4			3			9400
													//				5			2			9500
													//				6			1			9600
													// 8			0			8			9000
													//				1			7			9100
													//				2			6			9200
													//				3			5			9300
													//				4			4			9400
													//				5			3			9500
													//				6			2			9600
													//				7			1			9700
													// 9			0			9			9000
													//				1			8			9100
													//				2			7			9200
													//				3			6			9300
													//				4			5			9400
													//				5			4			9500
													//				6			3			9600
													//				7			2			9700
													//				8			1			9800
		int best_scope = 9000 + 100*depth;			// scope of rival
		int best_from = -1;							// best move from
		int best_to = -1;							// best move to
		int best_capture = -1;						// best capture

		if (main == 1) System.out.print(location2string(++move));
		else location2string(++move);

		for (int step=0; step<35; step++)			// automatic movements
		{											// 0...23 possible automatic moves starting on the field
			if ((step < 25) || (step == 34)			// 24, 34 possible automatic moves starting from the stack
			 && (-9000 - 100*depth < best_scope))	// -9000 already found a way to win => no further search
			{
				if (read(step) == 1 + move%2)		// if a token of the right color is on the search position
				{
					int options = marking(step);
					if (0 < options)
					{
						for (int a=0; a<24; a++)
						{
							if (read(a) < 0)
							{
								options = marking(a);
								int scope;
								if (0 < options)	// mill
								{
									for (int b=0; b<24; b++)
									{
										if (read(b) < 0)
										{
											if (marking(b) < 0)				// -1 white has lost, -2 black has lost, -3 not possible
											{
												best_scope = -9000 - 100*depth;
												best_from = step;
												best_to = a;
												best_capture = b;
												a = b = 24;					// no further testing
											}
											else							// -9000 - 100*depth < best_scope
											{
												if (depth == 0)
												{
													scope = score(2 - move%2);
												}
												else
												{
													scope = 9000 + 100*depth;
													Token token_sub = new Token(ATTACK);
													token_sub.string2location(location2string(move));
													scope = -token_sub.calculate(depth - 1, 0);
												}

												if (0 < scope)				// long term profit (token.value = -2 ... -4),
												{							// especially if token on crossing is captured
													scope += value(b, 33) - ATTACK;	// -ATTACK more aggressive
													if (scope < 1) scope = 1;		// not lower than 1, because not best
												}
												else scope += value(b, 33) - ATTACK;// -ATTACK more aggressive

												if (scope < best_scope)
												{
													best_scope = scope;
													best_from = step;
													best_to = a;
													best_capture = b;
												}

												if ((scope != 9000 + 100*depth) &&	// if possible move found and ...
													(scope == best_scope))			// ... in case of equal result ...
												{									// ... take a look at position
													if (best_to == -1)		// previous choice without capture
													{						// => use new choice with capture
														best_scope = scope;
														best_from = step;
														best_to = a;
														best_capture = b;
													}
													else
													{						// prefer central mill
														if (value(best_from, best_to) < value(step, a))
														{
															best_scope = scope;
															best_from = step;
															best_to = a;
															best_capture = b;
														}					// prefer capturing central token
														if (value(best_from, best_to) == value(step, a))
														{
															if (0 < value(best_to, a))
															{
																best_scope = scope;
																best_from = step;
																best_to = a;
																best_capture = b;
															}
														}
													}
												}
											}
											undo();
										}
									}
								}
								else						// no mill
								{
									if (depth == 0)
									{
										scope = score(2 - move%2);
									}
									else
									{
										scope = 9000 + 100*depth;
										Token token_sub = new Token(ATTACK);
										token_sub.string2location(location2string(move));
										scope = -token_sub.calculate(depth - 1, 0);
									}
									if (scope < best_scope)
									{
										best_scope = scope;
										best_from = step;
										best_to = a;
									}
									if ((scope != 9000 + 100*depth) &&	// if possible move found and ...
										(scope == best_scope))			// ... in case of equal result ...
									{									// ... take a look at position
										if (value(best_from, best_to) < value(step, a))
										{
											best_scope = scope;
											best_from = step;
											best_to = a;
										}
									}
								}
								undo();
								options = marking(step);
							}
						}
						undo();
					}
				}
			}
		}

		if (main == 1)
		{
			System.out.print(" s:");
			System.out.print(best_scope);
			if (-1 < best_from)
			{
				System.out.print(" ");
				System.out.print(best_from);
				System.out.print("->");
				System.out.print(best_to);
				if (-1 < best_capture)
				{
					System.out.print(" ");
					System.out.print(best_capture);
				}
			}
			System.out.print("\t");
		}

		return best_scope;
	}


	//////////////////////////////////////////////////////////////////////////
	//                                                //                    //
	// location[0...43] = {0 empty, 1 white, 2 black} // move = 0000...9999 //
	//                                                //                    //
	//////////////////////////////////////////////////////////////////////////

	public String location2string(int move)
	{
		char[] chars = new char[48];

		for (int a=0; a<44; a++)
			chars[a] = (char)('0' + location[a]);
		for (int a=0; a<4; a++)
		{
			int c = move%10;
			chars[47 - a] = (char)('0' + c);
			move = move/10;
		}
		return new String(chars);
}


	public int string2location(String str)
	{
		if (str.length() == 48)
		{
			for (int a=0; a<44; a++)
				location[a] = str.charAt(a) - '0';
			put[0] = 0;
			for (int a=24; a<34; a++)
			{
				if (location[a] == 1) put[0]++;
				if (location[a] == 2) capture[1]++;
			}
			put[1] = 0;
			for (int a=34; a<44; a++)
			{
				if (location[a] == 2) put[1]++;
				if (location[a] == 1) capture[0]++;
			}
			return move = Integer.parseInt(str.substring(44));
		}
		else return 0;
	}



	/* related to id */

	public int read(int id)
	{
		return location[id];
	}


	public int value(int from, int to)
	{
		int result;
		result = 0;

/*		if (from < 0)								faster without tests
		{
			System.out.println("");
			System.out.println("from < 0");
			System.exit(0);
		}
		if (to < 0)
		{
			System.out.println("");
			System.out.println("to < 0");
			System.exit(0);
		}
		if (43 < from)
		{
			System.out.println("");
			System.out.println("43 < from");
			System.exit(0);
		}
		if (43 < to)
		{
			System.out.println("");
			System.out.println("43 < to");
			System.exit(0);
		} */

		if (-1 < neighbor[from][2]) result--;
		if (-1 < neighbor[from][3]) result--;
		if (-1 < neighbor[to][2]) result++;
		if (-1 < neighbor[to][3]) result++;

		return result;
	}


	public void move(int id0, int id1)
	{
		if (posput[0] <= id0)
		{
			put[location[id0] - 1]--;
			id0 = posput[location[id0] - 1] + put[location[id0] - 1];
		}
		if (posput[0] <= id1)
		{
			id1 = posput[location[id0] - 1] + put[location[id0] - 1];
			put[location[id0] - 1]++;
		}
		location[id1] = location[id0];
		location[id0] = 0;
	}


	public int take(int id)
	{
		int result;
		result = 0;	// 0 default, -1 white has lost, -2 black has lost

		if (location[id] == 1)					// white
		{
			location[poscapture[1] - capture[0]] = 1;
			if (++capture[0] == 4 + 3*nine) result = -1;
		}
		else									// black
		{
			location[poscapture[0] - capture[1]] = 2;
			if (++capture[1] == 4 + 3*nine) result = -2;
		}
		location[id] = 0;
		return result;
	}


	public int release(int id, int color)
	{
		int result;
		result = 0;	// 0 default, -1 white not lost, -2 black not lost

		if (color == 1)							// captured by white
		{
			if (capture[1]-- == 4 + 3*nine) result = -2;
			location[poscapture[0] - capture[1]] = 0;
		}
		else									// captured by black
		{
			if (capture[0]-- == 4 + 3*nine) result = -1;
			location[poscapture[1] - capture[0]] = 0;
		}
		location[id] = 3 - color;
		return result;
	}


	public int marking(int id)
	{
		int options;
		options = 0;

		if (id < 0)								// invalid id
		{
			if (from != -2)
			{
				if (id == -1)
				{
					for (int a=0; a<24; a++)	// remove marked
						if (location[a] < 0) location[a] = 0;
				}
				from = -1;
			}
			options = -3;			
		}
		else									// valid id
		{
			if (from == -2)
			{
				if (location[id] < 0)			// capture
				{
					for (int a=0; a<24; a++)	// marked => unmarked
						if (location[a] < 0) location[a] = -location[a];
					captured = id;				// save in case of undo
					options = take(id);			// 0 default, -1 white has lost, -2 black has lost
					from = -1;
				}
				else options = -3;				// capture not possible
			}
			else								// move or mark
			{
				switch (location[id])
				{
					case  0: break;						// none
					case -1: 							// white marked
					case -2: for (int a=0; a<24; a++)	// black marked
							 {
								if (location[a] < 0) location[a] = 0;
							 }
							 move(from, id);
							 captured = -1;				// id of last captured token
							 movefrom = from;			// last move from id
							 moveto = id;				// last move to id
							 from = mill(id);
							 if (from == -2)
							 {
								for (int a=0; a<24; a++)
								{
									if (location[a] == 3 - location[id])
									{
										if (-1 == mill(a))
										{				// mark possible tokens for capture
											location[a] = -location[a];
											options++;
										}
									}
								}
								if (options == 0)
								{
									if (wma_rule == 1)	// WMA rule:
									{					// no token outside mill available => mark any rival token
										for (int a=0; a<24; a++)
										{
											if (location[a] == 3 - location[id])
											{			// mark possible tokens for capture
												location[a] = -location[a];
												options++;
											}
										}
										if (options == 0) from = -1;
									}
									else from = -1;		// WMD rule
								}
							 }
			 				 break;
					case  1: 							// possibly mark white
					case  2: if (from == -1)			// possibly mark black
							 {
								if (put[location[id] - 1] == 0)
								{						// nothing to set
									if ((3 + 3*nine <= capture[location[id] - 1]) && (australia == 0))
									{					// jump
										for (int a=0; a<24; a++)
										{
											if (location[a] == 0)
											{
												location[a] = -location[id];
												options++;
											}
										}
									}
									else
									{
										for (int a=0; a<4; a++)
										{				// move
											if (-1 < neighbor[id][a])
											{
												if (location[neighbor[id][a]] == 0)
												{
													location[neighbor[id][a]] = -location[id];
													options++;
												}
											}
										}
									}
								}
								else					// setting
								{
									if (24 <= id)
									{
										for (int a=0; a<24; a++)
										{
											if (location[a] == 0)
											{
												location[a] = -location[id];
												options++;
											}
										}
									}
								}
								if (0 < options) from = id;
								if (0 == options) options = -3;
							 }
							 else
							 {
								for (int a=0; a<24; a++)// delete from
								{
									if (location[a] < 0) location[a] = 0;
								}
								from = -1;
								options = -3;
							 }
							 break;
				}
			}
		}
		return options;
	}


	public int undo()
	{
		int result;

		if (-1 < captured)								// undo capture
		{
			if (-1 < from)
			{
				// -1 < captured
				// -1 < from
				//////////////////////////////////////////////////////////
				//      //      //         ////      //      //         //
				// MARK // MOVE // CAPTURE //// MARK //      //         //
				//      //      //         ////      //      //         //
				//////////////////////////////////////////////////////////
				//               <------------------
				for (int a=0; a<24; a++)				// remove marked
					if (location[a] < 0) location[a] = 0;
				from = -1;
			}
			// -1 < captured
			// -1 == from
			//////////////////////////////////////////////////////////
			//      //      //         ////      //      //         //
			// MARK // MOVE // CAPTURE //// MARK //      //         //
			//      //      //         ////      //      //         //
			//////////////////////////////////////////////////////////
			//               <--------------
			// 0 default, -1 white not lost, -2 black not lost
			result = release(captured, location[moveto]); // undo take
			captured = -1;
			from = -2;
			int options = 0;
			for (int a=0; a<24; a++)
			{
				if (location[a] == 3 - location[moveto])
				{
					if (-1 == mill(a))
					{				// mark possible tokens for capture
						location[a] = -location[a];
						options++;
					}
				}
			}
			if (options == 0)
			{
				if (wma_rule == 1)	// WMA rule:
				{					// no token outside mill available => mark any rival token
					for (int a=0; a<24; a++)
					{
						if (location[a] == 3 - location[moveto])
						{			// mark possible tokens for capture
							location[a] = -location[a];
						}
					}
				}
				else
				{
					System.out.println("");
					System.out.println("Error in Undo");
					System.exit(0);
				}
			}
		}
		else											// no capture
		{
			if (-1 < from)
			{
				if (-1 < movefrom)
				{
					// -1 == captured
					// -1 < from
					//////////////////////////////////////////////////////////
					//      //      //         ////      //      //         //
					// MARK // MOVE //         //// MARK //      //         //
					//      //      //         ////      //      //         //
					//////////////////////////////////////////////////////////
					// <--------------------------------
					for (int a=0; a<24; a++)				// remove marked
						if (location[a] < 0) location[a] = 0;
					from = -1;
					move(moveto, movefrom);					// move token back
					location[moveto] = 0;
					movefrom = -1;
					moveto = -1;
					result = 5;						// undo marking and moving
				}
				else
				{
					// -1 == captured
					// -1 < from
					//////////////////////////////////////////////////////////
					//      //      //         ////      //      //         //
					// MARK //      //         ////      //      //         //
					//      //      //         ////      //      //         //
					//////////////////////////////////////////////////////////
					// <--
					for (int a=0; a<24; a++)				// remove marked
						if (location[a] < 0) location[a] = 0;
					from = -1;
					result = 2;								// undo marking
				}
			}
			else
			{
				if (-1 < movefrom)
				{ 
					if (from == -1)
					{
						// -1 == captured
						// -1 == from
						//////////////////////////////////////////////////////////
						//      //      //         ////      //      //         //
						// MARK // MOVE //         //// MARK //      //         //
						//      //      //         ////      //      //         //
						//////////////////////////////////////////////////////////
						// <----------------------------
						move(moveto, movefrom);					// move token back
						location[moveto] = 0;
						movefrom = -1;
						moveto = -1;
						result = 4;								// undo last move
					}
					else
					{
						// -1 == captured
						// -2 == from
						//////////////////////////////////////////////////////////
						//      //      //         ////      //      //         //
						// MARK // MOVE // CAPTURE ////      //      //         //
						//      //      //         ////      //      //         //
						//////////////////////////////////////////////////////////
						// <-------------
						for (int a=0; a<24; a++)			// marked => unmarked
							if (location[a] < 0) location[a] = -location[a];
						from = -1;
						move(moveto, movefrom);					// move token back
						location[moveto] = 0;
						movefrom = -1;
						moveto = -1;
						result = 3;									// undo move
					}
				}
				else
				{
					// -1 == captured
					// -1 == from
					//////////////////////////////////////////////////////////
					//      //      //         ////      //      //         //
					//      //      //         ////      //      //         //
					//      //      //         ////      //      //         //
					//////////////////////////////////////////////////////////
					//
					result = 1;							// undo not possible
				}
			}
		}
		return result;
	}


	public int mill(int id)
	{
		if ((location[line[id][0]] == location[id]) && (location[line[id][1]] == location[id])) return -2;
		if ((location[line[id][2]] == location[id]) && (location[line[id][3]] == location[id])) return -2;
		return -1;
	}



	/* related to position */

	public int search(int x, int y)
	{
		int id = -1;
		for (int a=0; a<44; a++)
		{
			if (((x == position[a][1]) || (x + 1 == position[a][1]) || (x - 1 == position[a][1])) &&
				((y == position[a][0]) || (y + 1 == position[a][0]) || (y - 1 == position[a][0])))
			{
				if (a < posput[0]) id = a;
				else
				{
					if (a < posput[1])
					{
						if (location[a] == 1) id = a;
					}
					else
					{
						if (location[a] == 2) id = a;
					}
				}
			}
		}
		return id;
	}


	public int x(int id)
	{
		return position[id][1];
	}


	public int y(int id)
	{
		return position[id][0];
	}



	/* related to color */

	public int score_print(int color)
	{
		int scope = 0;					// moves possible at all
		int first = 1;					// no sign if first
		int add;

		if ((3 + 3*nine == capture[color - 1]) && (australia == 0))
		{
			for (int a=0; a<24; a++)	// jump => scope = 1...4
			{
				if (location[a] == color)
				{
					add = 0;
					if ((location[line[a][0]] == color) && (location[line[a][1]] == 0)) add++;
					if ((location[line[a][1]] == color) && (location[line[a][0]] == 0)) add++;
					if ((location[line[a][2]] == color) && (location[line[a][3]] == 0)) add++;
					if ((location[line[a][3]] == color) && (location[line[a][2]] == 0)) add++;
					System.out.print(add);
					System.out.print(" + ");
					scope += add;
				}
			}
			System.out.print("1");
			scope++;
		}
		else
		{
			for (int a=0; a<44; a++)
			{
				if ((a < 25) || (a == 34))	// 0...23 possible automatic moves starting on the field
				{							// 24, 34 possible automatic moves starting from the stack
					if (location[a] == color)
					{
						add = marking(a);
						if (0 < add)
						{
							scope += add;
							if (first == 1) first = 0;
							else System.out.print(" + ");
							System.out.print(add);
						}
						marking(-1);
					}
				}
			}
		}
		System.out.print(" = ");
		System.out.print(scope);
		System.out.print(" ");
		return scope;
	}

	public int score(int color)
	{
		int scope = 0;					// moves possible at all
		int add;

		if ((3 + 3*nine == capture[color - 1]) && (australia == 0))
		{
			for (int a=0; a<24; a++)	// jump => scope = 1...4
			{
				if (location[a] == color)
				{
					if ((location[line[a][0]] == color) && (location[line[a][1]] == 0)) scope++;
					if ((location[line[a][1]] == color) && (location[line[a][0]] == 0)) scope++;
					if ((location[line[a][2]] == color) && (location[line[a][3]] == 0)) scope++;
					if ((location[line[a][3]] == color) && (location[line[a][2]] == 0)) scope++;
				}
			}
			scope++;
		}
		else
		{
			for (int a=0; a<44; a++)
			{
				if ((a < 25) || (a == 34))	// 0...23 possible automatic moves starting on the field
				{							// 24, 34 possible automatic moves starting from the stack
					if (location[a] == color)
					{
						add = marking(a);
						if (0 < add) scope += add;
						marking(-1);
					}
				}
			}
		}
		return scope;
	}
}



	  /*    24    23 ---------------16 ---------------17     34    *
	   *           |                 |                 |           *
	   *    25     |                 |                 |     35    *
	   f           |    15 --------- 8 --------- 9     |           f
	   o    26     |     |           |           |     |     36    o
	   r           |     |           |           |     |           r
	   *    27     |     |     7 --- 0 --- 1     |     |     37    *
	   s           |     |     |           |     |     |           s
	*  e    28     |     |     |           |     |     |     38    e  *
	*  t          22 ---14 --- 6           2 ---10 ---18           t  *
	c  t    29     |     |     |           |     |     |     39    t  c
	a  i           |     |     |           |     |     |           i  a
	p  n    30     |     |     5 --- 4 --- 3     |     |     40    n  p
	t  g           |     |           |           |     |           g  t
	u  *    31     |     |           |           |     |     41    *  u
	r  *           |    13 ---------12 ---------11     |           *  r
	e  *    32     |                 |                 |     42    *  e
	d              |                 |                 |              d
	*       33    21 ---------------20 ---------------19     43


			 1234567890123456789012345678901234567890123456789		  */
