#!/bin/bash
#
# Script
# - removes all 0xxxxx files
# - copy NMM.jar from mintaka to all other used hosts
# - write host.txt
#
# (C) 2011 Dr. Klaus Rieger <rieger@ari.uni-heidelberg.de>
#

####################
# FUNCTION
####################

print_info_host()
{
  echo "copy NMM to $HOST..."
  echo $HOST >> host.txt
}


####################
# Remove
# 0xxxxx
####################

echo "***********************************************************************"
echo "******************************** START ********************************"
echo "***********************************************************************"
echo
echo "remove all 0xxxxx files..."
rm 0?????
echo "remove host.txt..."
rm host.txt
echo


####################
# Copy NMM via
# globus-url-copy
####################

HOST="aprilia.izbi.uni-leipzig.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://aprilia.izbi.uni-leipzig.de/u/homes/astrogrid/dgad0117/NMM.jar
# copy needs infinit time

HOST="arminius-grid.uni-paderborn.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://arminius-grid.uni-paderborn.de
# host doesn't work at all

HOST="astar.aip.de"
print_info_host;
globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://astar.aip.de/work/gridspace/agd107/NMM.jar

HOST="astrodata.astrogrid-d.org"
print_info_host;
globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://astrodata.astrogrid-d.org/work1/gridspace/agdusr107/NMM.jar

HOST="astrodata01.gac-grid.org"
print_info_host;
globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://astrodata01.gac-grid.org/work1/gridspace/agdusr107/NMM.jar

HOST="astrodata02.gac-grid.org"
print_info_host;
globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://astrodata02.gac-grid.org/work1/gridspace/agdusr107/NMM.jar

HOST="astrodata03.gac-grid.org"
print_info_host;
globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://astrodata03.gac-grid.org/work1/gridspace/agdusr107/NMM.jar

HOST="astrodata04.gac-grid.org"
print_info_host;
globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://astrodata04.gac-grid.org/work1/gridspace/agdusr107/NMM.jar

HOST="astrodata05.gac-grid.org"
print_info_host;
globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://astrodata05.gac-grid.org/work1/gridspace/agdusr107/NMM.jar

HOST="astrodata06.gac-grid.org"
print_info_host;
globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://astrodata06.gac-grid.org/work1/gridspace/agdusr107/NMM.jar

HOST="astrodata07.gac-grid.org"
print_info_host;
globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://astrodata07.gac-grid.org/work1/gridspace/agdusr107/NMM.jar

HOST="astrodata08.gac-grid.org"
print_info_host;
globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://astrodata08.gac-grid.org/work1/gridspace/agdusr107/NMM.jar

HOST="astrodata09.gac-grid.org"
print_info_host;
globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://astrodata09.gac-grid.org/work1/gridspace/agdusr107/NMM.jar

HOST="astrodata10.gac-grid.org"
print_info_host;
globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://astrodata10.gac-grid.org/work1/gridspace/agdusr107/NMM.jar

HOST="bladekemper21.informatik.tu-muenchen.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://bladekemper21.informatik.tu-muenchen.de/home/grid/gridpool84/NMM.jar
# 2011-05-04 host don't work any more

HOST="bwgrid-cluster.scc.kit.edu"
print_info_host;
globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://bwgrid-cluster.scc.kit.edu/bwfs/ka/localhome/dgad0117/NMM.jar

HOST="cashmere.aip.de"
print_info_host;
globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://cashmere.aip.de/work2/gridspace/agd107/NMM.jar

HOST="damiana.aei.mpg.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://damiana.aei.mpg.de
# host doesn't work at all

HOST="dgsi.zah.uni-heidelberg.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://dgsi.zah.uni-heidelberg.de
# host doesn't work at all

HOST="dublin.aip.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://dublin.aip.de
# host doesn't work at all

HOST="emilia.zih.tu-dresden.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://emilia.zih.tu-dresden.de/home/ziad0117/NMM.jar
# copy OK, but no calculation

HOST="erebos.aip.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://erebos.aip.de/home/Agrid/agrid107/NMM.jar
# host doesn't work at all

HOST="gavo1.aip.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://gavo1.aip.de/work1/gridspace/agdusr107/NMM.jar
# 2011-05-04 host don't work any more

HOST="gavo3.aip.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://gavo3.aip.de/work1/gridspace/agd107/NMM.jar
# 2011-03-30 don't work any more since today

HOST="gavosrv1.mpe.mpg.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://gavosrv1.mpe.mpg.de/work1/gridspace/agdusr107/NMM.jar
# 2010-12-14 stop working because certificate expired

HOST="gcwn60.d-grid.uni-hannover.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://gcwn60.d-grid.uni-hannover.de/
# host doesn't work at all

HOST="globus.bfg.uni-freiburg.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://globus.bfg.uni-freiburg.de/gridhome/dgad0117/NMM.jar
# copy OK, but no calculation

HOST="globus-bisgrid.uni-paderborn.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://globus-bisgrid.uni-paderborn.de/home-pc2/user/dgad0117/NMM.jar
# copy OK, but no calculation

HOST="globus-hn.mathematik.uni-marburg.de"
print_info_host;
globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://globus-hn.mathematik.uni-marburg.de/home/d-grid/dgad0117/NMM.jar

HOST="gloria.d-grid.scai.fraunhofer.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://gloria.d-grid.scai.fraunhofer.de/home/dgad0117/NMM.jar
# copy OK, but no calculation

HOST="golowood.mao.kiev.ua"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://golowood.mao.kiev.ua/home/mao1/Agrid/agrid107/NMM.jar
# host doesn't work at all

HOST="grid01.hs-esslingen.de"
print_info_host;
globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://grid01.hs-esslingen.de/home/local/grid/esad0117/NMM.jar

HOST="NMM to gridmon.gwdg.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://gridmon.gwdg.de/
# host doesn't work at all

HOST="gt4-fzk.gridka.de"
print_info_host;
globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://gt4-fzk.gridka.de/grid/fzk.de/home/astrogrid/dgad0117/NMM.jar

HOST="gt4.uni-tuebingen.de"
print_info_host;
globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://gt4.uni-tuebingen.de/dgrid-link/tuad0117/NMM.jar

HOST="gtbw.grid.uni-mannheim.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://gtbw.grid.uni-mannheim.de/bwfs/scratch/temphomes/grid/mhad0117/NMM.jar
# copy OK, but no calculation

HOST="iwrgt4.fzk.de"
print_info_host;
globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://iwrgt4.fzk.de/fzk/dgrid/localhome/dgad0117/NMM.jar

HOST="juggle-glob.fz-juelich.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://juggle-glob.fz-juelich.de/direct/home/astro/dgad0117/NMM.jar
# copy OK, but no calculation

HOST="koios.rz.uni-ulm.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://koios.rz.uni-ulm.de/users/dgrid/uladgrp1/ulad0117/NMM.jar
# copy OK, but no calculation

HOST="lxgt2.lrz-muenchen.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://lxgt2.lrz-muenchen.de/home/cluster/pr42di/lu26gav2/NMM.jar
# copy OK, but no calculation

HOST="mardschana.zib.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://mardschana.zib.de/home/dgad0117/NMM.jar
# copy OK, but no calculation

HOST="medigrid-srv.gwdg.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://medigrid-srv.gwdg.de/usr/users/dgad0117/NMM.jar
# copy OK, but no calculation

HOST="mintaka.ari.uni-heidelberg.de"
print_info_host;
globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://mintaka.ari.uni-heidelberg.de/home/Agrid/agrid107/NMM.jar

HOST="nimrod.med.uni-goettingen.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://nimrod.med.uni-goettingen.de/home/astrogrid/dgad0117/NMM.jar
# copy OK, but no calculation

HOST="photon.aip.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://photon.aip.de/work1/gridspace/agdusr107/NMM.jar
# 2010-12-10 copy need infinite time

HOST="portal.astrogrid-d.org"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://portal.astrogrid-d.org/
# host doesn't work at all

HOST="sigrid.zimt.uni-siegen.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://sigrid.zimt.uni-siegen.de/home/dgad0117/NMM.jar
# copy OK, but no calculation

HOST="srvgrid01.offis.uni-oldenburg.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://srvgrid01.offis.uni-oldenburg.de/home/d-grid-users/dgad0117/NMM.jar
# copy OK, but no calculation

HOST="stuttgart-globus.iao.fraunhofer.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://stuttgart-globus.iao.fraunhofer.de/
# host doesn't work at all

HOST="titan.ari.uni-heidelberg.de"
print_info_host;
globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://titan.ari.uni-heidelberg.de/home/Tit2/Agrid/agrid107/NMM.jar

HOST="udo-gt01.grid.tu-dortmund.de"
# print_info_host;
# globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://udo-gt01.grid.tu-dortmund.de/home/ad/ad0117/NMM.jar
# works sometimes, very weak host
# copy OK, but no calculation

HOST="udo-gt03.grid.tu-dortmund.de"
print_info_host;
globus-url-copy file:/home/Agrid/agrid107/NMM.jar gsiftp://udo-gt03.grid.tu-dortmund.de/home8/dgad0117/NMM.jar


echo

####################
# completed
####################

echo "***********************************************************************"
echo "****************************** COMPLETED ******************************"
echo "***********************************************************************"
